/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.graphics.font;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import icyllis.modernui.graphics.textmc.pipeline.TextRenderType;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.math.vector.Matrix4f;

public class TexturedGlyph {
    private RenderType renderType;
    private RenderType seeThroughType;
    private float advance;
    private float baselineX;
    private float baselineY;
    private float width;
    private float height;
    private float u1;
    private float v1;
    private float u2;
    private float v2;

    public TexturedGlyph() {
        this.renderType = this.seeThroughType = Atlases.func_228782_g_();
    }

    public TexturedGlyph(int textureName, float advance, float baselineX, float baselineY, float width, float height, float u1, float v1, float u2, float v2) {
        this.init(textureName, advance, baselineX, baselineY, width, height, u1, v1, u2, v2);
    }

    public void init(int textureName, float advance, float baselineX, float baselineY, float width, float height, float u1, float v1, float u2, float v2) {
        if (this.renderType instanceof TextRenderType) {
            throw new IllegalStateException("Already initialized");
        }
        this.renderType = TextRenderType.getOrCacheType(textureName, false);
        this.seeThroughType = TextRenderType.getOrCacheType(textureName, true);
        this.advance = advance;
        this.baselineX = baselineX;
        this.baselineY = baselineY;
        this.width = width;
        this.height = height;
        this.u1 = u1;
        this.v1 = v1;
        this.u2 = u2;
        this.v2 = v2;
    }

    public void drawGlyph(@Nonnull IVertexBuilder builder, float x, float y, int r, int g2, int b, int a) {
        if (this.renderType instanceof TextRenderType) {
            RenderSystem.bindTexture((int)((TextRenderType)this.renderType).textureName);
            builder.func_225582_a_((double)(x += this.baselineX), (double)(y += this.baselineY), 0.0).func_225586_a_(r, g2, b, a).func_225583_a_(this.u1, this.v1).func_181675_d();
            builder.func_225582_a_((double)x, (double)(y + this.height), 0.0).func_225586_a_(r, g2, b, a).func_225583_a_(this.u1, this.v2).func_181675_d();
            builder.func_225582_a_((double)(x + this.width), (double)(y + this.height), 0.0).func_225586_a_(r, g2, b, a).func_225583_a_(this.u2, this.v2).func_181675_d();
            builder.func_225582_a_((double)(x + this.width), (double)y, 0.0).func_225586_a_(r, g2, b, a).func_225583_a_(this.u2, this.v1).func_181675_d();
        }
    }

    public void drawGlyph(Matrix4f matrix, @Nonnull IRenderTypeBuffer buffer, float x, float y, int r, int g2, int b, int a, boolean seeThrough, int packedLight) {
        IVertexBuilder builder = buffer.getBuffer(seeThrough ? this.seeThroughType : this.renderType);
        builder.func_227888_a_(matrix, x += this.baselineX, y += this.baselineY, 0.0f).func_225586_a_(r, g2, b, a).func_225583_a_(this.u1, this.v1).func_227886_a_(packedLight).func_181675_d();
        builder.func_227888_a_(matrix, x, y + this.height, 0.0f).func_225586_a_(r, g2, b, a).func_225583_a_(this.u1, this.v2).func_227886_a_(packedLight).func_181675_d();
        builder.func_227888_a_(matrix, x + this.width, y + this.height, 0.0f).func_225586_a_(r, g2, b, a).func_225583_a_(this.u2, this.v2).func_227886_a_(packedLight).func_181675_d();
        builder.func_227888_a_(matrix, x + this.width, y, 0.0f).func_225586_a_(r, g2, b, a).func_225583_a_(this.u2, this.v1).func_227886_a_(packedLight).func_181675_d();
    }

    public float getAdvance() {
        return this.advance;
    }
}

